/*
 * Copyright (c) 2004 Mellanox Technologies LTD. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * $Id: TraceRoute.h 7501 2006-05-25 18:50:23Z eitan $
 */

#ifndef IBDM_FABRIC_TRACE_ROUTE_H
#define IBDM_FABRIC_TRACE_ROUTE_H

#include "Fabric.h"

// Trace a direct route from the given SM node port 
int TraceDRPathRoute (IBPort *p_smNodePort, list_int drPathPortNums);

// Trace a route from slid to dlid by Min Hop
int TraceRouteByMinHops (IBFabric *p_fabric, 
  unsigned int slid , unsigned int dlid);

// Trace a route from slid to dlid by LFT
int TraceRouteByLFT (IBFabric *p_fabric, 
                     unsigned int slid , unsigned int dlid,
                     unsigned int *hops, list_pnode *p_nodesList);

#endif /* IBDM_FABRIC_TRACE_ROUTE_H */
